#include <stdio.h>
#include <stdlib.h>

typedef struct {
    int x;
    int h;
    int index;
} Jarbole;

int cmp(const void *a, const void *b) {
    Jarbole *ja = (Jarbole*)a;
    Jarbole *jb = (Jarbole*)b;
    if (ja->x != jb->x) return ja->x - jb->x;
    return 0;
}

int main() {
    int n;
    scanf("%d", &n);
    Jarbole *jarbole = (Jarbole*)malloc(n * sizeof(Jarbole));
    int *x_arr = (int*)malloc(n * sizeof(int));
    int *h_arr = (int*)malloc(n * sizeof(int));

    for (int i = 0; i < n; i++) {
        scanf("%d", &jarbole[i].x);
        jarbole[i].index = i;
    }
    for (int i = 0; i < n; i++) {
        scanf("%d", &jarbole[i].h);
    }


    qsort(jarbole, n, sizeof(Jarbole), cmp);


    int *rez = (int*)malloc(n * sizeof(int));
    for (int i = 0; i < n; i++) {
        rez[i] = -1;
    }

    for (int i = 0; i < n; i++) {
        int xi = jarbole[i].x;
        int hi = jarbole[i].h;

      
        int left_x, right_x;
        if (i == 0) {
            left_x = 0; // Pramac
        } else {
           
            left_x = (jarbole[i-1].x + xi) / 2;
        }

        if (i == n - 1) {
            right_x = 1000000000; 
        } else {
            right_x = (xi + jarbole[i+1].x) / 2;
        }

       

       
        int dist_left = -1, dist_right = -1;

      
        if (left_x >= 0 && left_x <= right_x) {
            int height_left = (left_x <= xi) ? (-left_x + (xi + hi)) : (left_x - (xi - hi));
            if (height_left >= hi) {
                dist_left = abs(xi - left_x);
            }
        }

        
        if (right_x >= 0 && right_x <= 1000000000) {
            int height_right = (right_x <= xi) ? (-right_x + (xi + hi)) : (right_x - (xi - hi));
            if (height_right >= hi) {
                dist_right = abs(xi - right_x);
            }
        }

       
        int height_at_xi = hi; 
        if (height_at_xi >= hi) {
            rez[jarbole[i].index] = 0; 
        } else {
        
            int min_dist = -1;
            if (dist_left != -1) min_dist = dist_left;
            if (dist_right != -1) {
                if (min_dist == -1 || dist_right < min_dist)
                    min_dist = dist_right;
            }
            rez[jarbole[i].index] = min_dist;
        }
    }


    for (int i = 0; i < n; i++) {
        printf("%d\n", rez[i]);
    }

    free(jarbole);
    free(x_arr);
    free(h_arr);
    free(rez);
    return 0;
}